function writecricsample(sample, filename)
% WRITECRICSAMPLE write a CRIC sample to a file (Competing Risks Interval Censoring)
%   WRITECRICSAMPLE(SAMPLE, FILENAME) writes the CRIC sample SAMPLE to file FILENAME
%     SAMPLE must have the format as RANDCRICSAMPLE generates them, so it should be
%       a struct with fields t1, t2, k1, k2 and K.
%     FILENAME will be the file to write to using MatLab fopen rules

% check input
n = length(sample.t1);
if length(sample.t2) ~= n; error('SAMPLE.t2 is not of the same length as SAMPLE.t1'); end
if length(sample.k1) ~= n; error('SAMPLE.k1 is not of the same length as SAMPLE.t1'); end
if length(sample.k2) ~= n; error('SAMPLE.k2 is not of the same length as SAMPLE.t1'); end
if ~isscalar(sample.K); error('SAMPLE.K is not a scalar'); end
if max(sample.k2) > sample.K; error('There are failure causes in SAMPLE.k2 larger than numCauses'); end
if ~isequal(unique(sample.k2(find(sample.k2 >= 0)))', 1:sample.K); warning('Not all failure causes 1 ... SAMPLE.K occur in SAMPLE.k2'); end

% make all vectors row vectors
t1 = rowvec(sample.t1);
k1 = rowvec(sample.k1);
t2 = rowvec(sample.t2);
k2 = rowvec(sample.k2);

% open file
[f, errmsg] = fopen(filename,'w');
if f == -1; error(['cannot open file ' filename ' for write access due to: ' errmsg]); end

% write file
fprintf(f,'%d\n%d\n',n,sample.K);
fprintf(f,'%g %g %d %d\n',[t1; t2; k1; k2]);

% close file
fclose(f);
