function dist = uniformdist(a, b)
% UNIFORMDIST computes a uniform distribution ~ U(a,b)
%   DIST = UNIFORMDIST(A, B)
%     A and B are scalars that are parameters for the uniform distribution, A < B.
%     DIST will describe the distribution; it is a structure with fields x and F with:
%       F(i) = P(X <= x(i)), X ~ U(A,B).

% input checks
if nargin ~= 2; error('wrong number of parameters'); end
if ~isscalar(a); error('parameter a is not a scalar'); end
if ~isscalar(b); error('parameter b is not a scalar'); end
if a>=b; error('parameter a is larger than or equal to parameter b'); end

% distribution creation
dist = struct('x',[a; b], 'F', [0; 1]);
