function showicm(s)

numTimes = length(s.T);
numIterations = length(s.iteration);

distFig = figure; % get a figure for dist plotting

for i = 1:numIterations
    dists = s.iteration(i).dists;
    
    figure(distFig);
    clf;
    axis([min(s.T) max(s.T) 0 1]);
    hold on;
    for k = 1:s.K
        indices = find(s.distIndex{k});
        plot(s.T(indices),dists(k).start);
    end
    
    waitforbuttonpress;
end

while waitforbuttonpress; end % wait for mouse click

close(distFig);