function s = readoutput(filename)
% READOUTPUT reads a file in the comprisk output format
%   S = READOUTPUT(FILENAME)
%     FILENAME must identify a file
%     See the help on fopen for details of the searchpath used
%     S will be a struct with the fields in the file

[f, msg ]= fopen(filename, 'r');
if f < 0; error(['Cannot open file ' filename ' for reading because: ' msg]); end

while 1
    fieldname = fscanf(f, '%s', 1);
	if length(fieldname) == 0;
        break; % eof
	end
	[token, rem] = strtok(fieldname,':');
    
    if strcmp(rem,':') % single vector
        [rval, count] = fscanf(f, '%f');
    elseif strcmp(rem,'::') % table with column headings
        fgetl(f); % skip rest of line
        % get headings
        headingstr = fgetl(f);
        headings = {};
        while 1
           [heading, headingstr] = strtok(headingstr);
           if isempty(heading); break; end
           headings = {headings{:} heading};
        end
        % fetch table
        [table, count] = fscanf(f,'%f',[length(headings), Inf]);
        % convert to a struct
        if count
            rval = struct(headings{1},table(1,:));
        else
            rval = struct(headings{1},[]);
        end
        for i = 2:length(headings)
            if count
                rval = setfield(rval,headings{i},table(i,:));
            else
                rval = setfield(rval,headings{i},[]);
            end
        end
    else
        error(['Declaration should end with : or ::, but found: "' fieldname '"']);
    end
    try
        e = ['s.' token ' = rval;'];
        eval(e);
    catch
        s = size(rval);
        error(sprintf('Error evaluating "%s": "%s"; size(rval) = %d %d',e,lasterr,s(1),s(2)));
    end
end

st = fclose(f);
if st < 0; error(['Error closing file ' filename]); end
