function dist = normaldist(mu, sigma, x)
% NORMALDIST computes a normal distribution ~ N(mu,sigma^2)
%   DIST = NORMALDIST(MU, SIGMA, X)
%     MU and SIGMA > 0 are scalars that are parameters for the uniform distribution
%     DIST will describe the distribution; it is a structure with fields x and F with:
%       F(i) = P(X <= x(i)), X ~ N(MU,SIGMA).
%     DIST.x is given by the parameter X and should be monotonically non-decreasing

% input checks
if nargin ~= 3; error('wrong number of parameters'); end
if ~isscalar(mu); error('parameter MU is not a scalar'); end
if ~isscalar(sigma); error('parameter SIGMA is not a scalar'); end
if ~isvector(x); error('parameter X is not a vector'); end
if ~isnumeric(x); error('parameter X is not numeric'); end
if sigma<=0; error('parameter SIGMA is not strictly positive'); end

% distribution creation
dist = struct('x',x,'F',0.5.*erfc(-((x-mu)./sigma)./sqrt(2)));
