function b = isvector(v)
% ISVECTOR determines whether a variable is a (row or column) vector
%   B = ISVECTOR(V) returns true if and only if:
%     - length(size(V)) == 2, and
%     - min(size(V)) == 1

b = length(size(v)) == 2 & min(size(v)) == 1;