function dist = exponentialdist(lambda, x)
% EXPONENTIALDIST computes a normal distribution ~ N(mu,sigma^2)
%   DIST = EXPONENTIALDIST(LAMBDA, X)
%     LAMBDA > 0 is a scalar that is a parameter for the exponential distribution with expectation 1/lambda
%     DIST will describe the distribution; it is a structure with fields x and F with:
%       F(i) = P(X <= x(i)), X ~ Exp(LAMBDA), E[X] = 1/LAMBDA.
%     DIST.x is given by the parameter X and should be monotonically non-decreasing

% input checks
if nargin ~= 2; error('wrong number of parameters'); end
if ~isscalar(lambda); error('parameter LAMBDA is not a scalar'); end
if ~isvector(x); error('parameter X is not a vector'); end
if ~isnumeric(x); error('parameter X is not numeric'); end
if lambda<=0; error('parameter LAMBDA is not strictly positive'); end

% distribution creation
dist = struct('x',x,'F',(x>=0).*(1-exp(-lambda.*x)));
