% script generating some nice small cric samples

x = 0:0.01:15;
dists =  ...
 [struct('x',x,'F',0.5*getfield(normaldist(3,2,x),'F')+0.5*getfield(normaldist(7,2,x),'F')) ...
  struct('x',x,'F',0.3*getfield(normaldist(4,1,x),'F')+0.7*getfield(normaldist(6,1,x),'F')) ...
  struct('x',x,'F',getfield(normaldist(5,2,x),'F'))];
weights = [0.3 0.2 0.5];

exnum = 4;

% generate sample
for num = 1:exnum
    numstr = int2str(num);
    samplefile = ['example' numstr '.sample.txt'];
    solutionfile = ['example' numstr '.solution.txt'];
	if fileexists(samplefile)
        fprintf('%s already exists; skipping sample generation\n',samplefile);
    else
		fprintf('generating %s\n',samplefile);
		switch (num)
        case 1
            obs = randobs(10000, discretedist([0 2 4 6 8 10], [0.1 0.2 0.2 0.2 0.2 0.1]), discretedist([1 2 3 4 5], [0.2 0.3 0.2 0.2 0.1]));
        case 2
        	obs = randobs(10000, discretedist(0.1:0.1:10,ones(1,100)./100), discretedist([1 2 3 4 5], [0.2 0.3 0.2 0.2 0.1]));
        case 3
            obs = randobs(10000, discretedist(0.1:0.1:10,ones(1,100)./100), discretedist(1, 1));
        case 4
            obs = randobs(1000, discretedist(0.1:0.1:20,ones(1,200)./200), discretedist([1 2], [0.5 0.5]));
        otherwise
            error('invalid num');
        end
		writecricsample(randcricsample(dists, weights, obs),samplefile);
	end
    
    command = sprintf('comprisk -f -i %s -o %s -a 1e-4 -n 1000', samplefile, solutionfile);
    fprintf('running %s\n', command);
    result = dos(command);
    
    fprintf('reading %s\n', solutionfile)
    try
        s(num) = readoutput(solutionfile);
    catch
        fprintf('encountered an error: %s\n',lasterr);
    end
end

% plot the actual distributions
figure;
hold on;
axis([min(x) max(x) 0 1]);
for i = 1:length(dists)
    plot(dists(i).x,weights(i).*dists(i).F,'k');
end

% show results
colors = 'rgbymc';
for num = 1:exnum
    showsolution(s(num),colors(num));
end



