function dist = discretedist(v, p)
% DISCRETEDIST computes a general discrete distribution taking values in a finite set
%   DIST = DISCRETEDIST(V, P)
%     The distribution is described by P(X == V) = P.
%     So V contains values whose probabilities are given in P.
%     DIST will describe the distribution; it is a structure with fields x and F with:
%       F(i) = P(X <= x(i)), where X has the given discrete distribution.

% input checks
if nargin ~= 2; error('wrong number of parameters'); end
if ~isvector(v); error('parameter V is not a vector'); end
if ~isnumeric(v); error('parameter V is not numeric'); end
if ~isvector(p); error('parameter P is not a vector'); end
if ~isnumeric(p); error('parameter P is not numeric'); end
if abs(sum(p)-1)>1e8; error(sprintf('the probabilities in P don''t sum up to 1, but to %g',sum(p))); end

% distribution creation
[y, i] = sort(v);
y = rowvec(y);
yy = [y;y];
x = yy(:);
p = cumsum(rowvec(p(i)));
p = p(1:length(p)-1);
pp = [p;p];
F = pp(:);
F = [0; F(:); 1];
dist = struct('x',x,'F',F);