/*
 * File:        getopt.c
 * Author:      Bram Kuijvenhoven (bkuijvenhoven@student.tudelft.nl)
 * Date:        2005/07/23 [yyyy/mm/dd]
 * Description: Simple getopt implementation
 */

#include "getopt.h"
#include "stdlib.h"
#include "stdio.h"

int opterr = true;
int optopt = '\0';
int optind = 1;
char *optarg = NULL;

int getopt(int argc, char **argv, const char *options) {
	if (optind>=argc) return -1; // end of options
	if (argv[optind][0] != '-')	return -1; // first non-option encountered
	// handle option optchar
	int optchar = argv[optind][1];
	if (optchar == '\0') return -1; // only a - is not an option
	// find optchar in options
	const char *curopt = options;
	for (curopt = options; *curopt != '\0'; curopt++)
		if (*curopt == optchar)
			break;
	// handle found option
	if (*curopt == '\0') {
		// option encountered is not in options
		if (opterr) fprintf(stderr, "Unknown option %c encountered\n", optchar);
		optopt = optchar;
		return '?';
	}
	// option argument required?
	curopt++;
	bool argrequired = (* curopt == ':');
	// handle argument if required
	if (argrequired) {
		// check argument exists
		if (argv[optind][2] == '\0') {
			// argument should be in the next option
			optind++;
			if (optind >= argc) {
				if (opterr) fprintf(stderr, "Option %c must be followed by an argument\n", optchar);
				optopt = optchar;
				return '?';
			}
			optarg = argv[optind];
		} else {
			// argument is the rest of the option
			optarg = &(argv[optind][2]);
		}
	} else {
		optarg = NULL;
	}
	// option found
	optind++;
	return optchar;
}
