/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Preferences
extends Form
implements CommandListener {
    MineSweeper midlet;
    int width = 15;
    int height = 10;
    int bombs = 24;
    TextField widthField;
    TextField heightField;
    TextField bombsField;
    Command ok;
    PreferencesRMS preferencesRMS;

    public Preferences(MineSweeper m) {
        super("Preferences");
        this.midlet = m;
        this.widthField = new TextField("Width", Integer.toString(this.width), 2, 2);
        this.append((Item)this.widthField);
        this.heightField = new TextField("Height", Integer.toString(this.height), 2, 2);
        this.append((Item)this.heightField);
        this.bombsField = new TextField("Mines", Integer.toString(this.bombs), 3, 2);
        this.append((Item)this.bombsField);
        this.ok = new Command("Exit", 7, 0);
        this.addCommand(this.ok);
        this.setCommandListener(this);
        this.preferencesRMS = new PreferencesRMS();
        if (this.preferencesRMS != null) {
            this.preferencesRMS.readPreferences();
        }
    }

    public void storePreferences() {
        this.preferencesRMS.writePreferences();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBombCount() {
        return this.bombs;
    }

    protected void setWidth(int w) {
        this.width = w;
        this.widthField.setString(Integer.toString(w));
    }

    protected void setHeight(int h) {
        this.height = h;
        this.heightField.setString(Integer.toString(h));
    }

    protected void setBombCount(int b) {
        this.bombs = b;
        this.bombsField.setString(Integer.toString(b));
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.ok) {
            this.width = Integer.parseInt(this.widthField.getString());
            this.height = Integer.parseInt(this.heightField.getString());
            this.bombs = Integer.parseInt(this.bombsField.getString());
            this.midlet.returnFromPreferences();
        }
    }

    public class PreferencesRMS {
        private RecordStore recordStore;

        public PreferencesRMS() {
            try {
                this.recordStore = RecordStore.openRecordStore((String)"preferences", (boolean)true);
            }
            catch (RecordStoreException e) {
                this.handleException((Exception)((Object)e), "Could not create RecordStore");
            }
        }

        public void writePreferences() {
            if (this.recordStore == null) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            try {
                outputStream.writeInt(Preferences.this.getWidth());
                outputStream.writeInt(Preferences.this.getHeight());
                outputStream.writeInt(Preferences.this.getBombCount());
            }
            catch (IOException e) {
                this.handleException(e, "IOException while writing preferences");
            }
            byte[] b = baos.toByteArray();
            try {
                if (this.recordStore.getNumRecords() == 0) {
                    this.recordStore.addRecord(b, 0, b.length);
                } else {
                    this.recordStore.setRecord(1, b, 0, b.length);
                }
                System.out.println();
            }
            catch (RecordStoreException e) {
                this.handleException((Exception)((Object)e), "RecordStoreException while writing preferences");
            }
        }

        public void readPreferences() {
            if (this.recordStore == null) {
                return;
            }
            try {
                byte[] b = this.recordStore.getRecord(1);
                ByteArrayInputStream bais = new ByteArrayInputStream(b);
                DataInputStream inputStream = new DataInputStream(bais);
                Preferences.this.setWidth(inputStream.readInt());
                Preferences.this.setHeight(inputStream.readInt());
                Preferences.this.setBombCount(inputStream.readInt());
            }
            catch (InvalidRecordIDException e) {
            }
            catch (RecordStoreException e) {
                this.handleException((Exception)((Object)e), "RecordStoreException while reading preferences");
            }
            catch (IOException e) {
                this.handleException(e, "IOException while reading preferences");
            }
        }

        public void showMessage(String msg) {
            Alert alert = new Alert(msg, null, null, AlertType.ERROR);
            Display d = Display.getDisplay((MIDlet)Preferences.this.midlet);
            Displayable current = d.getCurrent();
            d.setCurrent((Displayable)alert);
            try {
                System.out.println(msg);
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (current != null) {
                d.setCurrent(current);
            }
        }

        public void handleException(Exception e, String msg) {
            System.out.println(msg);
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }
}

