/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MineSweeper
extends MIDlet
implements CommandListener {
    Display display = null;
    List mainMenu = new List("Main Menu", 3);
    Preferences preferences = null;
    Command exitCmd = new Command("Exit", 7, 1);
    Command chooseCmd = new Command("Choose", 4, 1);
    GameScreen screen = null;
    Instructions instructions = null;
    boolean gameRunning;

    public MineSweeper() {
        this.mainMenu.addCommand(this.exitCmd);
        this.mainMenu.addCommand(this.chooseCmd);
        this.mainMenu.setCommandListener((CommandListener)this);
        this.screen = new GameScreen(this);
        this.preferences = new Preferences(this);
        this.setPreferences();
        this.instructions = new Instructions(this);
        this.gameRunning = false;
        this.initMenuItems();
    }

    public void initMenuItems() {
        while (this.mainMenu.size() > 0) {
            this.mainMenu.delete(0);
        }
        if (this.gameRunning) {
            this.mainMenu.append("Continue Game", null);
        }
        this.mainMenu.append("New Game", null);
        this.mainMenu.append("Preferences", null);
        this.mainMenu.append("Instructions", null);
    }

    protected void startApp() throws MIDletStateChangeException {
        this.display = Display.getDisplay((MIDlet)this);
        this.display.setCurrent((Displayable)this.mainMenu);
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        this.preferences.storePreferences();
    }

    public void setPreferences() {
        this.screen.setPreferences(this.preferences.getWidth(), this.preferences.getHeight(), this.preferences.getBombCount());
    }

    public void returnFromPreferences() {
        this.setPreferences();
        this.display.setCurrent((Displayable)this.mainMenu);
    }

    public void returnFromInstructions() {
        this.display.setCurrent((Displayable)this.mainMenu);
    }

    public void returnFromGame() {
        boolean bl = this.gameRunning = this.screen.gameStatus == 0;
        if (this.gameRunning) {
            this.screen.pauseGame();
        } else {
            this.screen.exitGame();
        }
        this.initMenuItems();
        this.display.setCurrent((Displayable)this.mainMenu);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exitCmd) {
            try {
                this.destroyApp(true);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.notifyDestroyed();
        } else if (c == this.chooseCmd) {
            int idx = this.mainMenu.getSelectedIndex();
            if (this.gameRunning) {
                --idx;
            }
            switch (idx) {
                case -1: {
                    this.screen.resumeGame();
                    this.display.setCurrent((Displayable)this.screen);
                    break;
                }
                case 0: {
                    this.screen.run();
                    this.display.setCurrent((Displayable)this.screen);
                    break;
                }
                case 1: {
                    this.display.setCurrent((Displayable)this.preferences);
                    break;
                }
                case 2: {
                    this.display.setCurrent((Displayable)this.instructions);
                }
            }
        }
    }
}

