/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameScreen
extends Canvas
implements CommandListener {
    MineSweeper midlet = null;
    Font smallFont;
    Image[] imgSite;
    Image imgClosed;
    Image imgFlag;
    Image imgMine;
    int lastBombsLeftWidth;
    int lastStatusLeft;
    int lastStatusWidth;
    int lastClockLeft;
    int lastClockWidth;
    boolean bombsLeftChanged;
    boolean statusChanged;
    boolean clockChanged;
    boolean screenMoved;
    boolean[][] siteChanged;
    boolean cursorMovedNearLeft;
    boolean cursorMovedNearTop;
    int screenWidth;
    int screenHeight;
    int siteHeight;
    int siteWidth;
    static final int scrollBarSize = 2;
    int statusHeight;
    int windowWidth;
    int windowHeight;
    int windowOriginX;
    int windowOriginY;
    int maxWindowOriginX;
    int maxWindowOriginY;
    int fieldWidth;
    int fieldHeight;
    int bombCount;
    int newGameWidth;
    int newGameHeight;
    int newGameBombCount;
    int cursorX;
    int cursorY;
    int minRelCursorX;
    int minRelCursorY;
    int maxRelCursorX;
    int maxRelCursorY;
    long startTime;
    long pauseTime;
    int elapsedTime;
    Timer clockTimer;
    ClockTimerTask clockTimerTask;
    Command exit;
    protected Random random = null;
    public static final int BOMB = 16;
    public static final int OPEN = 32;
    public static final int FLAG = 64;
    protected int[][] field = null;
    protected int bombsLeft;
    protected int freeSitesLeft;
    public int gameStatus;
    public static final String[] statusDescription;
    public static final int PLAYING = 0;
    public static final int COMPLETED = 1;
    public static final int GAMEOVER = 2;
    public static final int ABORTED = 3;

    public GameScreen(MineSweeper m) {
        this.midlet = m;
        this.random = new Random();
        this.initGraphics();
        this.exit = new Command("Exit", 7, 0);
        this.addCommand(this.exit);
        this.setCommandListener(this);
    }

    public void setPreferences(int w, int h, int b) {
        this.newGameWidth = w;
        this.newGameHeight = h;
        this.newGameBombCount = b;
    }

    public void initGraphics() {
        this.smallFont = Font.getFont((int)32, (int)0, (int)8);
        this.statusHeight = this.smallFont.getHeight();
        this.loadImages();
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
    }

    public void loadImages() {
        this.imgSite = new Image[9];
        try {
            int i = 0;
            while (i < 9) {
                this.imgSite[i] = Image.createImage((String)("/site_" + i + ".png"));
                ++i;
            }
            this.imgClosed = Image.createImage((String)"/site_closed.png");
            this.imgFlag = Image.createImage((String)"/site_flag.png");
            this.imgMine = Image.createImage((String)"/site_mine.png");
        }
        catch (IOException e) {
            System.out.println("Could not load image: " + e.getMessage());
        }
        this.setSiteDimensions(this.imgClosed.getWidth(), this.imgClosed.getHeight());
    }

    public void setSiteDimensions(int w, int h) {
        this.siteWidth = w;
        this.siteHeight = h;
    }

    public void calcWindowAndCursorVars() {
        this.windowWidth = Math.min(this.fieldWidth, (this.screenWidth - 2 - 2) / this.siteWidth);
        this.windowHeight = Math.min(this.fieldHeight, (this.screenHeight - this.statusHeight - 2 - 2) / this.siteHeight);
        this.windowOriginX = 0;
        this.windowOriginY = 0;
        this.maxWindowOriginX = this.fieldWidth - this.windowWidth;
        this.maxWindowOriginY = this.fieldHeight - this.windowHeight;
        this.minRelCursorX = this.minRelCursorY = Math.min(this.windowWidth / 3, this.windowHeight / 3);
        this.maxRelCursorX = this.windowWidth - this.minRelCursorX - 1;
        this.maxRelCursorY = this.windowHeight - this.minRelCursorY - 1;
    }

    public void run() {
        this.initGame();
    }

    public void initGame() {
        this.bombCount = this.newGameBombCount;
        this.setDimensions(this.newGameWidth, this.newGameHeight);
        this.layMines(this.bombCount);
        this.calcWindowAndCursorVars();
        this.cursorX = 0;
        this.cursorY = 0;
        this.screenMoved = true;
        this.startTime = 0L;
        this.elapsedTime = 0;
        this.pauseTime = 0L;
        if (this.clockTimer != null) {
            this.clockTimer.cancel();
        }
        this.clockTimer = new Timer();
        this.lastBombsLeftWidth = 0;
        this.lastStatusLeft = 0;
        this.lastStatusWidth = 0;
        this.lastClockLeft = 0;
        this.lastClockWidth = 0;
        this.setAllChanged();
    }

    public void setDimensions(int w, int h) {
        if (this.field == null || this.fieldWidth != w || this.fieldHeight != h) {
            this.field = new int[w][h];
            this.siteChanged = new boolean[w][h];
            this.fieldWidth = w;
            this.fieldHeight = h;
        }
    }

    public void setGameStatus(int gs) {
        this.gameStatus = gs;
        this.statusChanged = true;
        if (gs == 2) {
            int i = 0;
            while (i < this.fieldWidth) {
                int j = 0;
                while (j < this.fieldHeight) {
                    if (this.hasBomb(i, j)) {
                        this.siteChanged[i][j] = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setBombsLeft(int bl) {
        this.bombsLeft = bl;
        this.bombsLeftChanged = true;
    }

    public void incBombsLeft() {
        this.setBombsLeft(this.bombsLeft + 1);
    }

    public void decBombsLeft() {
        this.setBombsLeft(this.bombsLeft - 1);
    }

    public void layMines(int count) {
        int x = 0;
        while (x < this.fieldWidth) {
            int y = 0;
            while (y < this.fieldHeight) {
                this.field[x][y] = 0;
                this.siteChanged[x][y] = true;
                ++y;
            }
            ++x;
        }
        int siteCount = this.fieldWidth * this.fieldHeight;
        if (count > siteCount) {
            count = siteCount;
        }
        int i = 0;
        while (i < count) {
            int ypos;
            int xpos;
            while (this.hasBomb(xpos = Math.abs(this.random.nextInt()) % this.fieldWidth, ypos = Math.abs(this.random.nextInt()) % this.fieldHeight)) {
            }
            this.setBomb(xpos, ypos, true);
            int x2 = xpos - 1;
            while (x2 <= xpos + 1) {
                if (0 <= x2 && x2 < this.fieldWidth) {
                    int y = ypos - 1;
                    while (y <= ypos + 1) {
                        if (0 <= y && y < this.fieldHeight && (x2 != xpos || y != ypos)) {
                            int[] nArray = this.field[x2];
                            int n = y;
                            nArray[n] = nArray[n] + 1;
                        }
                        ++y;
                    }
                }
                ++x2;
            }
            ++i;
        }
        this.bombCount = count;
        this.setBombsLeft(count);
        this.freeSitesLeft = siteCount - count;
        this.setGameStatus(0);
    }

    public void mark(int x, int y) {
        if (this.gameStatus != 0) {
            return;
        }
        if (this.isOpen(x, y)) {
            return;
        }
        if (!this.hasFlag(x, y)) {
            if (this.bombsLeft > 0) {
                this.setFlag(x, y, true);
                this.decBombsLeft();
                this.siteChanged[x][y] = true;
            }
        } else {
            this.setFlag(x, y, false);
            this.incBombsLeft();
            this.siteChanged[x][y] = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void sweepNonRecursive(int x, int y) {
        Object o;
        Queue queue = new Queue();
        --this.freeSitesLeft;
        this.setOpen(x, y, true);
        this.siteChanged[x][y] = true;
        queue.add(new SweepQueueItem(x, y));
        while (null != (o = queue.remove())) {
            void var4_4;
            SweepQueueItem item = (SweepQueueItem)var4_4;
            if (this.getNeighboorCount(item.x, item.y) != 0) continue;
            int i = item.x - 1;
            while (i <= item.x + 1) {
                if (0 <= i && i < this.fieldWidth) {
                    int j = item.y - 1;
                    while (j <= item.y + 1) {
                        if (!(0 > j || j >= this.fieldHeight || i == item.x && j == item.y || this.isOpen(i, j) || this.hasFlag(i, j))) {
                            --this.freeSitesLeft;
                            this.setOpen(i, j, true);
                            this.siteChanged[i][j] = true;
                            queue.add(new SweepQueueItem(i, j));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected void sweepRecursive(int x, int y) {
        if (this.isOpen(x, y) || this.hasFlag(x, y)) {
            return;
        }
        --this.freeSitesLeft;
        this.setOpen(x, y, true);
        this.siteChanged[x][y] = true;
        if (this.getNeighboorCount(x, y) == 0) {
            int i = x - 1;
            while (i <= x + 1) {
                if (0 <= i && i < this.fieldWidth) {
                    int j = y - 1;
                    while (j <= y + 1) {
                        if (0 <= j && j < this.fieldHeight && (i != x || j != y)) {
                            this.sweepRecursive(i, j);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void sweep(int x, int y) {
        if (this.gameStatus != 0) {
            return;
        }
        if (this.hasBomb(x, y)) {
            this.setGameStatus(2);
            return;
        }
        this.sweepNonRecursive(x, y);
        if (this.freeSitesLeft <= 0) {
            this.setGameStatus(1);
        }
    }

    protected void toggleFlag(int x, int y) {
        int[] nArray = this.field[x];
        int n = y;
        nArray[n] = nArray[n] ^ 0x40;
    }

    protected void setFlag(int x, int y, boolean f) {
        if (f) {
            int[] nArray = this.field[x];
            int n = y;
            nArray[n] = nArray[n] | 0x40;
        } else {
            int[] nArray = this.field[x];
            int n = y;
            nArray[n] = nArray[n] & 0xFFFFFFBF;
        }
    }

    protected void setOpen(int x, int y, boolean o) {
        if (o) {
            int[] nArray = this.field[x];
            int n = y;
            nArray[n] = nArray[n] | 0x20;
        } else {
            int[] nArray = this.field[x];
            int n = y;
            nArray[n] = nArray[n] & 0xFFFFFFDF;
        }
    }

    protected void setBomb(int x, int y, boolean b) {
        if (b) {
            int[] nArray = this.field[x];
            int n = y;
            nArray[n] = nArray[n] | 0x10;
        } else {
            int[] nArray = this.field[x];
            int n = y;
            nArray[n] = nArray[n] & 0xFFFFFFEF;
        }
    }

    public boolean hasBomb(int x, int y) {
        return (this.field[x][y] & 0x10) != 0;
    }

    public boolean isOpen(int x, int y) {
        return (this.field[x][y] & 0x20) != 0;
    }

    public boolean hasFlag(int x, int y) {
        return (this.field[x][y] & 0x40) != 0;
    }

    public int getNeighboorCount(int x, int y) {
        return this.field[x][y] % 16;
    }

    public void exitGame() {
        this.clockTimer.cancel();
    }

    public void pauseGame() {
        this.pauseTime = System.currentTimeMillis();
    }

    public void resumeGame() {
        this.startTime += System.currentTimeMillis() - this.pauseTime;
        this.setAllChanged();
    }

    protected void setSelection(int x, int y) {
        if (x != this.cursorX || y != this.cursorY) {
            this.siteChanged[this.cursorX][this.cursorY] = true;
            if (this.cursorX > 0) {
                this.siteChanged[this.cursorX - 1][this.cursorY] = true;
            } else {
                this.cursorMovedNearLeft = true;
            }
            if (this.cursorY > 0) {
                this.siteChanged[this.cursorX][this.cursorY - 1] = true;
            } else {
                this.cursorMovedNearTop = true;
            }
            if (this.cursorX > 0 && this.cursorY > 0) {
                this.siteChanged[this.cursorX - 1][this.cursorY - 1] = true;
            }
            this.siteChanged[x][y] = true;
            if (x > 0) {
                this.siteChanged[x - 1][y] = true;
            }
            if (y > 0) {
                this.siteChanged[x][y - 1] = true;
            }
            if (x > 0 && y > 0) {
                this.siteChanged[x - 1][y - 1] = true;
            }
        }
        if (x != this.cursorX) {
            this.cursorX = x;
            int relCursorX = this.cursorX - this.windowOriginX;
            if (relCursorX < this.minRelCursorX) {
                this.windowOriginX = Math.max(0, this.cursorX - this.minRelCursorX);
                this.screenMoved = true;
            }
            if (relCursorX > this.maxRelCursorX) {
                this.windowOriginX = Math.min(this.maxWindowOriginX, this.cursorX - this.maxRelCursorX);
                this.screenMoved = true;
            }
        }
        if (y != this.cursorY) {
            this.cursorY = y;
            int relCursorY = this.cursorY - this.windowOriginY;
            if (relCursorY < this.minRelCursorY) {
                this.windowOriginY = Math.max(0, this.cursorY - this.minRelCursorY);
                this.screenMoved = true;
            }
            if (relCursorY > this.maxRelCursorY) {
                this.windowOriginY = Math.min(this.maxWindowOriginY, this.cursorY - this.maxRelCursorY);
                this.screenMoved = true;
            }
        }
    }

    protected void setAllChanged() {
        this.bombsLeftChanged = true;
        this.statusChanged = true;
        this.clockChanged = true;
        this.screenMoved = true;
        this.cursorMovedNearLeft = true;
        this.cursorMovedNearTop = true;
    }

    protected void clearChanged() {
        this.bombsLeftChanged = false;
        this.statusChanged = false;
        this.clockChanged = false;
        this.screenMoved = false;
        this.cursorMovedNearLeft = false;
        this.cursorMovedNearTop = false;
        int i = 0;
        while (i < this.fieldWidth) {
            int j = 0;
            while (j < this.fieldHeight) {
                this.siteChanged[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    protected void paint(Graphics g) {
        String s;
        g.setFont(this.smallFont);
        if (this.bombsLeftChanged) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, this.lastBombsLeftWidth, this.statusHeight);
            s = Integer.toString(this.bombsLeft);
            this.lastBombsLeftWidth = this.smallFont.stringWidth(s);
            g.setColor(0xFF0000);
            g.drawString(s, 0, 0, 4 | 0x10);
        }
        if (this.statusChanged) {
            g.setColor(0xFFFFFF);
            g.fillRect(this.lastStatusLeft, 0, this.lastStatusWidth, this.statusHeight);
            s = statusDescription[this.gameStatus];
            this.lastStatusWidth = this.smallFont.stringWidth(s);
            this.lastStatusLeft = this.screenWidth / 2 - this.lastStatusWidth / 2;
            g.setColor(0xFF0000);
            g.drawString(s, this.lastStatusLeft, 0, 4 | 0x10);
        }
        if (this.clockChanged) {
            g.setColor(0xFFFFFF);
            g.fillRect(this.lastClockLeft, 0, this.lastClockWidth, this.statusHeight);
            s = Integer.toString(this.elapsedTime / 1000);
            this.lastClockWidth = this.smallFont.stringWidth(s);
            this.lastClockLeft = this.screenWidth - 1 - this.lastClockWidth;
            g.setColor(0xFF0000);
            g.drawString(s, this.lastClockLeft, 0, 4 | 0x10);
        }
        int wWidth = this.windowWidth * this.siteWidth;
        int wHeight = this.windowHeight * this.siteHeight;
        if (this.cursorMovedNearLeft) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, this.statusHeight, 1, wHeight + 1);
        }
        if (this.cursorMovedNearTop) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, this.statusHeight, wWidth + 1, 1);
        }
        int xMin = this.windowOriginX;
        int xMax = xMin + this.windowWidth;
        int yMin = this.windowOriginY;
        int yMax = yMin + this.windowHeight;
        int x = xMin;
        while (x < xMax) {
            int y = yMin;
            while (y < yMax) {
                if (this.screenMoved || this.siteChanged[x][y]) {
                    int relX = x - xMin;
                    int relY = y - yMin;
                    Image img = !this.isOpen(x, y) ? (this.gameStatus == 2 && this.hasBomb(x, y) ? this.imgMine : (this.hasFlag(x, y) ? this.imgFlag : this.imgClosed)) : this.imgSite[this.getNeighboorCount(x, y)];
                    g.drawImage(img, 1 + this.siteWidth * relX, this.statusHeight + 1 + this.siteHeight * relY, 0x10 | 4);
                    if (x == this.cursorX && y == this.cursorY) {
                        g.setColor(255);
                        g.drawRect(this.siteWidth * relX, this.statusHeight + this.siteHeight * relY, this.siteWidth, this.siteHeight);
                    }
                }
                ++y;
            }
            ++x;
        }
        if (this.screenMoved) {
            int hBarWidth = wWidth + 1;
            int hBarY = this.statusHeight + wHeight + 2;
            int vBarHeight = wHeight + 1;
            int vBarX = wWidth + 2;
            g.setColor(0xC0C0C0);
            g.fillRect(0, hBarY, hBarWidth, 2);
            g.fillRect(vBarX, this.statusHeight, 2, vBarHeight);
            g.setColor(255);
            g.fillRect(this.windowOriginX * hBarWidth / this.fieldWidth, hBarY, this.windowWidth * hBarWidth / this.fieldWidth, 2);
            g.fillRect(vBarX, this.statusHeight + this.windowOriginY * vBarHeight / this.fieldHeight, 2, this.windowHeight * vBarHeight / this.fieldHeight);
        }
        this.clearChanged();
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    protected void keyPressed(int keyCode) {
        this.serviceRepaints();
        int action = this.getGameAction(keyCode);
        switch (keyCode) {
            case 42: {
                action = 9;
                break;
            }
            case 35: {
                action = 10;
            }
        }
        switch (action) {
            case 1: {
                if (this.cursorY <= 0) break;
                this.setSelection(this.cursorX, this.cursorY - 1);
                this.repaint();
                break;
            }
            case 2: {
                if (this.cursorX <= 0) break;
                this.setSelection(this.cursorX - 1, this.cursorY);
                this.repaint();
                break;
            }
            case 5: {
                if (this.cursorX >= this.fieldWidth - 1) break;
                this.setSelection(this.cursorX + 1, this.cursorY);
                this.repaint();
                break;
            }
            case 6: {
                if (this.cursorY >= this.fieldHeight - 1) break;
                this.setSelection(this.cursorX, this.cursorY + 1);
                this.repaint();
                break;
            }
            case 9: {
                if (this.startTime == 0L) {
                    this.startTime = System.currentTimeMillis();
                    this.clockTimerTask = new ClockTimerTask();
                    this.clockTimer.scheduleAtFixedRate((TimerTask)this.clockTimerTask, 0L, 1000L);
                }
                this.sweep(this.cursorX, this.cursorY);
                if (this.gameStatus != 0) {
                    this.clockTimer.cancel();
                }
                this.repaint();
                break;
            }
            case 10: {
                this.mark(this.cursorX, this.cursorY);
                this.repaint();
            }
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exit) {
            this.midlet.returnFromGame();
            if (this.gameStatus != 0) {
                this.clockTimer.cancel();
            }
        }
    }

    static {
        scrollBarSize = 2;
        BOMB = 16;
        OPEN = 32;
        FLAG = 64;
        statusDescription = new String[]{"Playing", "Completed", "Game Over", "Aborted"};
        PLAYING = 0;
        COMPLETED = 1;
        GAMEOVER = 2;
        ABORTED = 3;
    }

    private class SweepQueueItem {
        int x;
        int y;

        public SweepQueueItem(int xIn, int yIn) {
            this.x = xIn;
            this.y = yIn;
        }
    }

    class ClockTimerTask
    extends TimerTask {
        ClockTimerTask() {
        }

        public void run() {
            GameScreen.this.elapsedTime = (int)(System.currentTimeMillis() - GameScreen.this.startTime);
            GameScreen.this.clockChanged = true;
            GameScreen.this.repaint();
        }
    }
}

